;name WELCOME
;author Marcus93
;strategy uses core view for hires graphics
;date 2006-12-30
;version 2
;======================================================================;
;
; Uses the Core View for "High Resolution Graphics". Draws a simple
; text message, eventually switching to a new line while printing
;
; If you set ARES to another CORE_ZOOM, then you need to adjust the
; variable

	ZOOM	EQU	5		; ENTER THE CURRENT ZOOM FACTOR HERE

;
;======================================================================;

	ORG start


CPR	EQU	400/ZOOM	; cells per row
REND	EQU	CPR-8		; when cursor-x beyond REND, a new line is invoked


dummy				; some dat for drawing a "pixel" with MOV
char	DAT		0	; pointer to the current pixel in the character "bitmap"
cursor	DAT	CPR*10,	0	; position of next column, stored y, x!
coords	DAT	0,	0	; x and y of the current pixel
deltax	DAT		0	; counter for width of character

start
cloop	MOV	>sptr,	char	; get the next character
	MOV.AB	#0,	deltax	; reset the width-counter

ploop	MOV	>char,	coords	; get the coordinates of the next pixel, incrementing the pointer
	JMZ.f	pdone,	coords	; end of character map reached?
	
	SLT.AB	coords,	deltax	; check if x-position is greater than current deltax
	MOV.AB	coords,	deltax	; if yes, store new deltax

	ADD.BA	cursor,	coords	; add cursor-x position to pixel-x
	MUL	#CPR,	coords	; y = y * CPR
	ADD.AB	coords,	coords	; x = x + y
	ADD.AB	cursor,	coords	; add cursor-y to pixel-adress

	MOV	dummy,	@coords	; "draw" the pixel
	
	JMP	ploop		; continue with next pixel


pdone	ADD.B	deltax,	cursor	; add character width to cursor
	ADD	#1,	cursor	; add extra column space

	SLT	#REND,	cursor	; cursor near right end of core view?
	JMP	noNL		; no - continue

	MOV	#0,	cursor	; yes - new line (x = 0)
	ADD.A	#CPR*6,	cursor	; (y = y + 6 Rows)

noNL	JMN	cloop,	sptr	; next character or die on End-Of-String



;============================================;
;          String "WELCOME TO ARES"          ;
;============================================;
CHAR	EQU	DAT

STRING		CHAR	W-char		; these give offsets from "char" to
		CHAR	E-char		; the first pixel of each character
		CHAR	L-char
		CHAR	C-char
		CHAR	O-char
		CHAR	M-char
		CHAR	E-char

		CHAR	SPACE-char
		CHAR	SPACE-char

		CHAR	T-char
		CHAR	O-char

		CHAR	SPACE-char
		CHAR	SPACE-char

		CHAR	A-char
		CHAR	R-char
		CHAR	E-char
		CHAR	S-char

sptr		DAT	STRING		; this points to the begin of the string
					; and will be incremented after output
					; of every character. When it points to
					; itself (Zero), output ends.

;==================================;
;          character maps          ;
;==================================;
; these are not really _bit_maps, but lists of coordinates.
; every pixel is listed by it's coordinate, relative to the
; top left position (0|0). Positive y point downwards!

PIXEL	EQU	DAT
		
SPACE DAT 0,0		; empty char (white space)
			; when this is printed, cursor moves
			; one column forward (to the right)

A	PIXEL	1,1	; coordinates for the letter "A"
	PIXEL	1,2	; x must begin in column 1,
	PIXEL	1,3	; because ...
	PIXEL	1,4
	PIXEL	2,0	;Column 1234
	PIXEL	2,3	; Row 0  XX
	PIXEL	3,0	; Row 1 X  X
	PIXEL	3,3	; Row 2 X  X
	PIXEL	4,1	; Row 3 XXXX
	PIXEL	4,2	; Row 4 X  X
	PIXEL	4,3
	PIXEL	4,4
	DAT 0,0		; ... 0,0 is the code for end-of-map

C	PIXEL	1,1
	PIXEL	1,2
	PIXEL	1,3
	PIXEL	2,0
	PIXEL	2,4
	PIXEL	3,0
	PIXEL	3,4
	DAT 0,0

E	PIXEL	1,0
	PIXEL	1,1
	PIXEL	1,2
	PIXEL	1,3
	PIXEL	1,4
	PIXEL	2,0
	PIXEL	2,2
	PIXEL	2,4
	PIXEL	3,0
	PIXEL	3,4
	DAT 0,0

L	PIXEL	1,0
	PIXEL	1,1
	PIXEL	1,2
	PIXEL	1,3
	PIXEL	1,4
	PIXEL	2,4
	PIXEL	3,4
	DAT 0,0

M	PIXEL	1,0
	PIXEL	1,1
	PIXEL	1,2
	PIXEL	1,3
	PIXEL	1,4
	PIXEL	2,1
	PIXEL	3,2
	PIXEL	4,1
	PIXEL	5,0
	PIXEL	5,1
	PIXEL	5,2
	PIXEL	5,3
	PIXEL	5,4
	DAT 0,0

O	PIXEL	1,1
	PIXEL	1,2
	PIXEL	1,3
	PIXEL	2,0
	PIXEL	2,4
	PIXEL	3,0
	PIXEL	3,4
	PIXEL	4,1
	PIXEL	4,2
	PIXEL	4,3
	DAT 0,0

R	PIXEL	1,0
	PIXEL	1,1
	PIXEL	1,2
	PIXEL	1,3
	PIXEL	1,4
	PIXEL	2,0
	PIXEL	2,2
	PIXEL	3,0
	PIXEL	3,2
	PIXEL	4,1
	PIXEL	4,3
	PIXEL	4,4
	DAT 0,0

S	PIXEL	1,1
	PIXEL	1,4
	PIXEL	2,0
	PIXEL	2,2
	PIXEL	2,4
	PIXEL	3,0
	PIXEL	3,3
	DAT 0,0

T	PIXEL	1,0
	PIXEL	2,0
	PIXEL	2,1
	PIXEL	2,2
	PIXEL	2,3
	PIXEL	2,4
	PIXEL	3,0
	DAT 0,0

W	PIXEL	1,0
	PIXEL	1,1
	PIXEL	1,2
	PIXEL	1,3
	PIXEL	2,4
	PIXEL	3,3
	PIXEL	4,4
	PIXEL	5,0
	PIXEL	5,1
	PIXEL	5,2
	PIXEL	5,3
	DAT 0,0